# 概要

2022年2月15日開催の Game Tech Night のゲームダッシュボード作成に利用したサンプルデータです。

https://gamingtechnight.connpass.com/event/238727/

全ファイル１行目をヘッダー行としたCSV形式になっています。

## 想定しているサンプルゲーム

ダンジョンクリア型のソーシャルゲームを想定しています。

* ダンジョンをクリアしてランクを挙げる
* 1人友達を呼んで共闘
* 武器、スキン、キャラなど課金が可能

## 対象ファイル


* dungeon.csv(3.9KB)
* gameplay.csv(661.3MB)
* login.csv(61.0MB)
* sales.csv(8.1MB)
* salesitem.csv(2.8KB)
* user.csv(8.8MB)

カッコ内はファイル容量


## 容量についての注意事項

上記対象ファイルに記載のファイル容量にある通り全ファイルで775.1MBの容量があります。
S3での保存、QuickSightでのSPICEの利用など無料枠の範囲を超えて有償となる可能性がございますので、容量用法をご確認の上、ご利用いただきますようお願いいたします。

# スキーマ
## user.csv

ゲームユーザーの情報です。
データ件数:100,000件

* id
	* ユーザID
* userName
	* ユーザー名
* totalTime
	 総プレイ時間(分)
* releasedDungeonId
	* 開放済みダンジョンID
* level
	* レベル
* clearTotalNum
	* ダンジョンクリア回数
* coin
	* 所持コイン(ゲーム内通貨)
* totalExp
	* 総獲得経験値
* friendsNum
	* フレンド数
* startTime
	* ゲーム開始日時
* lastLoginTime
	* 最終ログイン日時

## login.csv:

ゲームユーザーのログイン履歴情報です。
データ件数:2,005,830件

* userId
	* ユーザID
* loginTime
	* ログイン日時

## login.csv:

ゲームユーザーのログイン履歴情報です。
データ件数:2,005,830件

* userId
	* ユーザID
* loginTime
	* ログイン日時

## sales.csv

ユーザーがお金を払って購入した売上履歴情報です。
データ件数:115,369件

* id
	* 売上ID
* purchasedTime
	* 購入日時
* store	
	* 購入ストア
* userId
	* ユーザーID
* itemId
	* アイテムID
* itemName
	* 購入アイテム名
* price
	* 商品単価
* purchaseNum
	* 購入個数
* totalPrice
	* 合計金額


## salesitem.csv

ストアで販売される商品情報です。
データ件数:100件

* id
	* 商品ID
* itemName
	* アイテム名
* itemType
	* アイテムタイプ
* price
	* 料金

## gameplay.csv

ダンジョンでのゲームのプレイ履歴情報です。
データ件数:6,038,660件

* id
	* ゲームごとの一意のUUID
* startTime
	* 開始日時
* dungeonId
	* ダンジョンID
* userId
	* ユーザーID
* result
	* プレイ結果(Clear or Fail)
* playTime
	* プレイ時間(分)
* progress
	* プレイ進捗状況(100%中どこまでクリアできたか)
* friendId
	* フレンドのユーザーID
* userCharacterID
	* ユーザーの利用キャラクターID
* userCharacterName
	* ユーザーの利用キャラクター名
* userWeaponId
	* ユーザーの利用武器ID
* userWeaponName
	* ユーザーの利用武器名
* userSkinId
	* ユーザーの利用スキンID
* userSkinName
	* ユーザーの利用スキン名
* enemies1
	* 倒した敵1の数
* enemies2
	* 倒した敵2の数
* enemies3
	* 倒した敵3の数
* enemies4
	* 倒した敵4の数
* enemies5
	* 倒した敵5の数
* gainExp
	* 獲得経験値

## dungeon.csv

ダンジョンの情報です。
データ件数:100件

* id
	* ダンジョンID
* dungeonName
	* ダンジョン名
* releaseOrder
	* ダンジョンの開放順
* difficulty
	* 難易度
* limitTime
	* 制限時間
* enemies1
	* 登場する敵1の数
* enemies2
	* 登場する敵2の数
* enamies3
	* 登場する敵3の数
* enemies4
	* 登場する敵4の数
* enemies5
	* 登場する敵5の数